///////
     //
     //  MOBOTIX EventStream Client SDK 
     //
     //  See LICENSE_SDK included in the SDK package
     //
     //  Copyright (c) 2005 - 2016, MOBOTIX AG
     //  All rights reserved.
     //
///////
    
#ifndef MxPEG_Logger_HPP_
#define MxPEG_Logger_HPP_

#include <memory>
#include <ostream>
#include <fstream>
#include <mutex>

#include "MxPEG_SDK_Export.hpp"


namespace ie { namespace MxPEG
{

/*
 * An enumeration of the different log level.
 */
enum MxLogLevel {
    MxAlert = (1 << 0),
    MxError = (1 << 1),
    MxWarn = (1 << 2),
    MxInfo = (1 << 3),
    MxDebug = (1 << 4),
    MxAll = (MxAlert | MxError | MxWarn | MxInfo | MxDebug)
};

/*
 * Converts the log level to its corresponding string repesentation for human readable output.
*/
std::string logLevelToString(MxLogLevel level);


/**
 * @brief The MxPEG_LogBackend class
 */
class IE_INTERFACE_API MxPEG_LogBackend {

public:
    virtual ~MxPEG_LogBackend() {}
    virtual void doLog(const MxLogLevel level, const char * func, const int line, const char * message) = 0;
};


/*
 * Sets the global log level
 *
 * Default value: MxAll
 */
void setGlobalLogLevel(const MxLogLevel &level = MxLogLevel::MxAll);

}

}


#endif // MxPEG_Logger_HPP_
