///////
     //
     //  MOBOTIX EventStream Client SDK 
     //
     //  See LICENSE_SDK included in the SDK package
     //
     //  Copyright (c) 2005 - 2016, MOBOTIX AG
     //  All rights reserved.
     //
///////
    
#ifndef MXPEG_STREAMSPLITTER_HPP
#define MXPEG_STREAMSPLITTER_HPP
#include <vector>
#include <memory>
#include <string>
#include <fstream>
#include "MxPEG_SDK_Export.hpp"

namespace ie { namespace MxPEG {
class IE_INTERFACE_API MxPEG_StreamSplitter
{
public:
    typedef std::shared_ptr<MxPEG_StreamSplitter> shared_ptr_t;

    /**
     * Gets the next mxpeg frame.
     *
     * Returns true if the sequence is found
     */
    virtual
    std::shared_ptr<std::vector<char>> getNextFrame(std::size_t *start) = 0;

    virtual
    bool hasNextFrame() = 0;

    virtual
    ~MxPEG_StreamSplitter() {};

};

class IE_INTERFACE_API MxPEG_StreamSplitter_Factory {
public:
    /*
     * Creates a new instance of a MxPEG decoder class.
     *
     */
    static MxPEG_StreamSplitter::shared_ptr_t create(const char* in_filename);
};

}
}
#endif // MXPEG_STREAMSPLITTER_H
