///////
     //
     //  MOBOTIX EventStream Client SDK 
     //
     //  This software is licensed under the BSD license,
     //  http://www.opensource.org/licenses/bsd-license.php
     //
     //  Copyright (c) 2005 - 2016, MOBOTIX AG
     //  All rights reserved.
     //
     //  Redistribution and use in source and binary forms, with or without
     //  modification, are permitted provided that the following conditions are
     //  met:
     //
     //  - Redistributions of source code must retain the above copyright
     //    notice, this list of conditions and the following disclaimer.
     //
     //  - Redistributions in binary form must reproduce the above copyright
     //    notice, this list of conditions and the following disclaimer in the
     //    documentation and/or other materials provided with the distribution.
     //
     //  - Neither the name of MOBOTIX AG nor the names of its contributors may
     //    be used to endorse or promote products derived from this software
     //    without specific prior written permission.
     //
     //  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
     //  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
     //  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
     //  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
     //  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
     //  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
     //  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
     //  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
     //  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
     //  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
     //  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
     //
///////

#include "NotificationListener.h"
//#include "nlohmann/json.hpp"
#include <iostream>

/*
 * Please note: 
 * 
 * Right now the stack does not capture the responses of some of the internal 
 * setup calls that are sent to the camera. This means the notification listener 
 * will a couple of "unexpected notifications" (= notifications with internal IDs)
 * right after startup.
 * 
 */
NotificationListener::NotificationListener () 
{
   std::cout << "Creating NotificationListener" << std::endl;
}

NotificationListener::~NotificationListener () {}

void NotificationListener::notifyEvent(int id, const char * message) {
   std::cout << "listener got message: " << id << ": " << message << std::endl;
//   nlohmann::json j_message = nlohmann::json::parse(message);
//   if(j_message["id"].is_number()) {
//      auto message_id = j_message["id"].get<int>();
//
//      /*
//         * play will return "end of stream" when it reaches the end of th recorded content
//         */
//      if((m_export_task_id > 0) && (message_id == m_export_task_id)) {
//         m_export_result = std::string(message);
//         std::cout << "NotificationListener got export related message: "<< m_export_result << std::endl;
//         if(j_message["error"].is_array()){
//            std::cout << "NotificationListener export finished with: " << j_message["error"].at(1) << std::endl;
//            m_export_finished = true;
//         }
//      }
//      /*
//         * seek will return "pause" state and no error on success, it will an error like "end of stream" if
//         * no data is found for the specified time stamp
//         */
//      if((m_seek_task_id > 0) && (message_id == m_seek_task_id)) {
//         m_export_result = std::string(message);
//         std::cout << "NotificationListener got export related message: "<< m_export_result << std::endl;
//         if(j_message["error"].is_array()){
//            std::cout << "NotificationListener export finished with: " << j_message["error"].at(1) << std::endl;
//            m_export_finished = true;
//         } else{
//            m_seek_finished = true;
//         }
//      }
//   }
   m_message_map[id] = std::string(message);
}

bool NotificationListener::haveResult(int id, std::string & result) {
   auto message = m_message_map.find(id);
   if(message != m_message_map.end()) {
      result = message->second;
      return true;
   }
   return false;
}

void NotificationListener::clearResults() {
   m_message_map.clear();
}
