///////
     //
     //  MOBOTIX EventStream Client SDK 
     //
     //  This software is licensed under the BSD license,
     //  http://www.opensource.org/licenses/bsd-license.php
     //
     //  Copyright (c) 2005 - 2016, MOBOTIX AG
     //  All rights reserved.
     //
     //  Redistribution and use in source and binary forms, with or without
     //  modification, are permitted provided that the following conditions are
     //  met:
     //
     //  - Redistributions of source code must retain the above copyright
     //    notice, this list of conditions and the following disclaimer.
     //
     //  - Redistributions in binary form must reproduce the above copyright
     //    notice, this list of conditions and the following disclaimer in the
     //    documentation and/or other materials provided with the distribution.
     //
     //  - Neither the name of MOBOTIX AG nor the names of its contributors may
     //    be used to endorse or promote products derived from this software
     //    without specific prior written permission.
     //
     //  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
     //  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
     //  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
     //  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
     //  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
     //  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
     //  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
     //  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
     //  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
     //  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
     //  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
     //
///////
#include <iostream>
#include <sstream>
#include <fstream>
#include <iomanip>
#include <ctime>
#include <thread>
#include "FileLogBackend.h"

static std::recursive_mutex m_access_mutex;

namespace ie { namespace MxPEG
{

FileLogBackend::FileLogBackend(const std::string &filename, const bool &append)
    : MxPEG_LogBackend(),
    m_file_stream {new std::ofstream()}{
    m_file_stream->open(filename.c_str(), ((append) ? std::ios_base::app : (std::ios_base::openmode) 0) | std::ios_base::out);
}

void FileLogBackend::doLog(const MxLogLevel level, const char* func, const int line, const char* message) 
{
    std::lock_guard<std::recursive_mutex> lock(m_access_mutex);
    auto now = std::time(nullptr);
    auto tm = *std::localtime(&now);
    *m_file_stream << "["<< std::put_time(&tm, "%Y.%m.%d %H:%M:%S") << "]";
    *m_file_stream << "[" << std::left << std::setw(5) << level << "]"
                   << "[" << func << ":" << line << "]: " << message << std::endl;
    *m_file_stream << std::flush;
}

FileLogBackend::~FileLogBackend() {
    if (m_file_stream) {
        if (m_file_stream->is_open()) {
            m_file_stream->flush();
            m_file_stream->close();
        }
        delete m_file_stream;
    }

}
}
}
