///////
     //
     //  MOBOTIX EventStream Client SDK 
     //
     //  This software is licensed under the BSD license,
     //  http://www.opensource.org/licenses/bsd-license.php
     //
     //  Copyright (c) 2005 - 2016, MOBOTIX AG
     //  All rights reserved.
     //
     //  Redistribution and use in source and binary forms, with or without
     //  modification, are permitted provided that the following conditions are
     //  met:
     //
     //  - Redistributions of source code must retain the above copyright
     //    notice, this list of conditions and the following disclaimer.
     //
     //  - Redistributions in binary form must reproduce the above copyright
     //    notice, this list of conditions and the following disclaimer in the
     //    documentation and/or other materials provided with the distribution.
     //
     //  - Neither the name of MOBOTIX AG nor the names of its contributors may
     //    be used to endorse or promote products derived from this software
     //    without specific prior written permission.
     //
     //  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
     //  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
     //  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
     //  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
     //  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
     //  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
     //  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
     //  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
     //  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
     //  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
     //  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
     //
///////

#ifndef MXPEG_SRC_MXPEG_SINKSDL_HPP_
#define MXPEG_SRC_MXPEG_SINKSDL_HPP_

#include "MxPEG_SinkVideo.hpp"
#include <string>
#include <SDL.h>
    
using namespace ie::MxPEG;
    
class SinkVideo : public MxPEG_SinkVideo
{
public:
   SinkVideo (std::string name = "");

   virtual
   ~SinkVideo ();

protected:
   virtual
   MxPEG_ReturnCode doConsumeVideo(MxPEG_Image::unique_ptr_t buffer);

private:
   std::string cameraName;
   unsigned long renderedFrames;
   unsigned int surface_width;
   unsigned int surface_height;
#ifdef USE_SDL1
   SDL_Surface *surface;
#else
   SDL_Window *sdlScreen;
   SDL_Renderer *sdlRenderer;
   SDL_Texture *sdlTexture;
#endif
};

#endif /* MXPEG_SRC_MXPEG_SINKSDL_HPP_ */
