///////
     //
     //  MOBOTIX EventStream Client SDK 
     //
     //  This software is licensed under the BSD license,
     //  http://www.opensource.org/licenses/bsd-license.php
     //
     //  Copyright (c) 2005 - 2016, MOBOTIX AG
     //  All rights reserved.
     //
     //  Redistribution and use in source and binary forms, with or without
     //  modification, are permitted provided that the following conditions are
     //  met:
     //
     //  - Redistributions of source code must retain the above copyright
     //    notice, this list of conditions and the following disclaimer.
     //
     //  - Redistributions in binary form must reproduce the above copyright
     //    notice, this list of conditions and the following disclaimer in the
     //    documentation and/or other materials provided with the distribution.
     //
     //  - Neither the name of MOBOTIX AG nor the names of its contributors may
     //    be used to endorse or promote products derived from this software
     //    without specific prior written permission.
     //
     //  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
     //  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
     //  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
     //  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
     //  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
     //  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
     //  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
     //  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
     //  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
     //  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
     //  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
     //
///////
#include <iostream>
#include <fstream>
#include <sstream>
#include <vector>
#include <memory>

#include <MxPEG_StreamSplitter.hpp>
#include "mxpeg-decoder.h"

/*
 * Simple MxPEG decoding demo. Output formats are either YUV (planar 4:2:0, I420) or RGB (interleaved 4:4:4, bgra, RV32)
 */
int main(int argc, char**argv) {

    if(argc < 4 ) {
        std::cout  << "Call with " << argv[0] << "RGB|YUV <MxPEG-file> <Out-File>" << std::endl;
        exit(1);
    }

    string format(argv[1]);

    MxPEG_ImageMode mode;
    if (format == "RGB") {
        mode = MxPEG_ImageMode::im_RGB;
    } else {
        if (format == "YUV") {
            mode = MxPEG_ImageMode::im_YUV;
        } else {
            std::cout  << "Unknown stream format " << format << ".\n"
                       <<"Allowed formats are: RGB, YUV" << std::endl;
            exit(1);
        }
    }


    /*
     * Open input file with MxPEG encoded video frames.
     */
    ifstream mxgFile(argv[2], ifstream::binary);
    if(mxgFile.is_open()) {
        std::cout << "Using MxPEG source " << argv[2] << std::endl;
    } else {
        std::cout << "Failed to open mxpeg file: " << argv[2] << std::endl;
        exit(1);
    }

    size_t frames = 0;
    size_t start = 0;

    MxPEG_Decoder_API::shared_ptr_t decoder = MxPEG_Decoder_Factory::create(mode);
    ie::MxPEG:: MxPEG_StreamSplitter::shared_ptr_t splitter = MxPEG_StreamSplitter_Factory::create(argv[2]);
    if (splitter == nullptr) {
        std::cout << "Failed to create splitter instance for " << argv[2] << std::endl;
        exit(1);
    }

    while(splitter->hasNextFrame()) {
        std::shared_ptr<vector<char>> frame = splitter->getNextFrame(&start);
        if (frame && !frame->empty()) {
            frames++;
            std::stringstream stream;
            stream << frames << "-" << argv[3] << ".raw";
            ofstream rawFile(stream.str(), ifstream::binary);

            if(rawFile.is_open()) {
                std::cout << "Using " << stream.str() << " as target for RAW output" << std::endl;
            } else {
                std::cout << "Failed to open raw output file: " <<  stream.str() << std::endl;
                exit(1);
            }

            rawFile.write(reinterpret_cast<char *>(frame->data()), frame->size());
            rawFile.close();
            stream.str("");
            stream << frames << "-" << argv[3] << "-" <<"decoded";
            decode_frame(decoder, reinterpret_cast<uint8_t *>(frame->data()), frame->size(), stream.str());
        }
    }
    return  0;
}
